/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartGun
extends APacketEntity<PartGun> {
    private final Request stateRequest;
    private final ItemBullet bulletItem;
    private final int bulletQty;

    public PacketPartGun(PartGun gun, Request stateRequest) {
        super(gun);
        this.stateRequest = stateRequest;
        this.bulletItem = null;
        this.bulletQty = 0;
    }

    public PacketPartGun(PartGun gun, ItemBullet bullet, int bulletQty) {
        super(gun);
        this.stateRequest = Request.RELOAD_ONCLIENT;
        this.bulletItem = bullet;
        this.bulletQty = bulletQty;
    }

    public PacketPartGun(ByteBuf buf) {
        super(buf);
        this.stateRequest = Request.values()[buf.readByte()];
        if (this.stateRequest == Request.RELOAD_ONCLIENT) {
            this.bulletItem = (ItemBullet)PacketPartGun.readItemFromBuffer(buf);
            this.bulletQty = buf.readInt();
        } else {
            this.bulletItem = null;
            this.bulletQty = 0;
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.stateRequest.ordinal());
        if (this.stateRequest == Request.RELOAD_ONCLIENT) {
            PacketPartGun.writeItemToBuffer(this.bulletItem, buf);
            buf.writeInt(this.bulletQty);
        }
    }

    @Override
    public boolean handle(AWrapperWorld world, PartGun gun) {
        switch (this.stateRequest) {
            case CLEAR_ONCLIENT: {
                gun.clearBullets();
                break;
            }
            case RELOAD_ONCLIENT: {
                gun.setReloadVars(this.bulletItem, this.bulletQty);
                break;
            }
            case RELOAD_HAND: {
                gun.isHandHeldGunReloadRequested = true;
                break;
            }
            case TRIGGER_ON: {
                gun.playerHoldingTrigger = true;
                gun.playerPressedTrigger = true;
                break;
            }
            case TRIGGER_OFF: {
                gun.playerHoldingTrigger = false;
                break;
            }
            case AIM_ON: {
                gun.isHandHeldGunAimed = true;
                break;
            }
            case AIM_OFF: {
                gun.isHandHeldGunAimed = false;
                break;
            }
            case BULLETS_OUT: {
                gun.bulletsPresentOnServer = false;
                break;
            }
            case BULLETS_PRESENT: {
                gun.bulletsPresentOnServer = true;
                break;
            }
            case HANDHELD_MOVEMENTS: {
                gun.performGunHandheldMovements();
            }
        }
        return this.stateRequest.sendToClients;
    }

    public static enum Request {
        CLEAR_ONCLIENT(false),
        RELOAD_ONCLIENT(false),
        RELOAD_HAND(false),
        TRIGGER_ON(true),
        TRIGGER_OFF(true),
        AIM_ON(true),
        AIM_OFF(true),
        BULLETS_OUT(false),
        BULLETS_PRESENT(false),
        HANDHELD_MOVEMENTS(true);

        private final boolean sendToClients;

        private Request(boolean sendToClients) {
            this.sendToClients = sendToClients;
        }
    }
}

